'use strict'

let framerateCap = window.framerateCap;
let showDebugInfo = false
let doPerf = false
let gui = null
let renderer = null
let debugTexts = []
let audioSampleData = []

let expressionParserCache = new ExpressionParserCache({
        pi: Math.PI,
        twopi: Math.PI*2,
    },
    {
        sin: (args) => Math.sin(args[0]),
        asin: (args) => Math.asin(args[0]),
        cos: (args) => Math.cos(args[0]),
        acos: (args) => Math.acos(args[0]),
        tan: (args) => Math.tan(args[0]),
        atan: (args) => Math.atan(args[0]),
        atan2: (args) => Math.atan2(args[0], args[1]),
        square: (args) => ((args[0] / (Math.PI*2)) % 1) < .5 ? +1 : -1,
        sawup: (args) => ((args[0] / (Math.PI*2)) % 1)*2-1,
        sawdown: (args) => ((args[0] / (Math.PI*2)) % 1)*-2+1,

        exp: (args) => Math.exp(args[0]),
        log: (args) => Math.log(args[0]),
        log10: (args) => Math.log10(args[0]),
        sqrt: (args) => Math.sqrt(args[0]),
        pow: (args) => Math.pow(args[0], args[1]),
        floor: (args) => Math.floor(args[0]),
        ceil: (args) => Math.ceil(args[0]),
        round: (args) => Math.round(args[0]),
        abs: (args) => Math.abs(args[0]),

        radians: (args) => args[0] * Math.PI/180,
        degrees: (args) => args[0] * 180/Math.PI,

        max: (args) => Math.max(...args),
        min: (args) => Math.max(...args),
        clamp: (args) => {
            const [v, min, max] = [...args]
            return Math.min(Math.max(v, min), max)
        },
        lerp: (args) => {
            const [min, max, v] = [...args]
            return (v - min) / (max - min)
        },

        volume: (args) => {
            let [t, sampleSize] = [...args]
            t = Math.floor(t * 50 * 60/bpm)
            sampleSize = typeof sampleSize === 'undefined' ? 5 : sampleSize
            let v = 0
            for (let i = -sampleSize; i < sampleSize; ++i) {
                const boundT = Math.max(0, Math.min(t + i, audioSampleData.length-1))
                v += audioSampleData[boundT]
            }
            return v / (sampleSize * 2)
        },
        sync: (args) => readInstrumentSync(args[0]),
        midicc: (args) => {
            if (typeof args[0] === 'string') {
                return midiCcValue(args[0], args[1] - 1, args[2]) / 127
            } else {
                return midiGlobalCcValue(args[0] - 1, args[1]) / 127
            }
        },
    })

let frameTimeGraphData = Array.from({length: 100}, () => 0)
let fpsCount = 0
let fpsCounter = 0
const fpsCountFunction = () => {
    fpsCount = fpsCounter
    fpsCounter = 0
    window.setTimeout(fpsCountFunction, 1000)
}

fpsCountFunction()

let moduleRunStringsIndent = null

window.entities = entitiesMaker()

const bpm = 100
const ticksPerLine = sync.globals.TicksPerLine
const linesPerBeat = sync.globals.LinesPerBeat
const syncs = Object.values(sync.patterns)

const msPerBeat = (1000*60)/bpm
const msPerLine = msPerBeat / linesPerBeat

const instrumentIds = {
    // name: [instrumentId, noteLength, decaySpeed, generatedNoteData, fakeSyncData]
    'bassdrum':     [2, 1, 0.030, [], [
        40, 41.83,42,42.33, 44, 45.83,46,46.33,
        48, 49.83,50,50.33, 52, 53.83,54,54.33,
        56, 57.83,58,58.33,     61.83,62,62.33,
        64, 65.83,66,66.33, 68, 69.83,70,70.33,

        72, 73.83,74,74.33,     77.83,78,78.33,
            77.83,78,78.33, 80, 81.83,82,82.33,
        80, 81.83,82,82.33, 84, 85.83,86,86.33,
        84, 85.83,86,86.33,

        92, 93.83,94.33, 96, 97.83,98.33,
        100, 101.83,102.33, 104, 105.83,106.33,
        108, 109.83,110.33, 112, 113.83,114.33,
        116, 117.83,118.33, 120, 121.83,122.33,
        124, 125.83,126.33, 128, 129.83,130.33,
        128, 129.83,130.33, 132, 133.83,134.33,
    ]],
    'snare1':       [3, 10, 0.01, [], [
        41, 43, 45, 47, 49, 51, 53, 55,
        57, 59, 61, 63, 65, 67, 69, 71,
        73, 75, 77, 79, 81, 83, 85, 87,

        91,
        93, 95, 97, 99, 101, 103, 105,
        107, 109, 111, 113, 115, 117, 119, 121,
        123, 125, 127, 129, 131, 133, 135, 137,
        139, 141, 143, 145, 147, 149, 151, 153,
        155,
    ]],
    // 'snare2':       [4, 10, 0.1, []],
    // 'bass':         [23, 10, 0.1, []],
    // 'longbd':       [14, 10, 0.1, []],
    // 'glitchbd':     [20, 10, 0.1, []],
    // 'glitch1':      [4, 10, 0.1, []],
    // 'glitch2':      [5, 10, 0.1, []],
    // 'glitch3':      [6, 10, 0.1, []],
    // 'dubbd':        [13, 10, 0.1, []],
    // 'dubsnare':     [15, 10, 0.1, []],
}
Object.values(instrumentIds).forEach(instrumentData => {
    const instrumentId = instrumentData[0]
    const noteLength = instrumentData[1]
    const noteDecay = instrumentData[2]
    const fakeSyncData = instrumentData[4]

    // let lastNoteOnSyncCursor = null
    let value = 0
    let noteOnLength
    for (let i = 0; i < 200*300; ++i) {
        const ms = (i * 10) * (60 / bpm)
        const syncCursor = (ms / msPerLine) / 4
        // if (syncCursor !== lastNoteOnSyncCursor) {
            // lastNoteOnSyncCursor = syncCursor

            // if (fakeSyncData) {
                // const beat = Math.floor(i/10000 / (bpm/60/1000))
                // if (fakeSyncData.includes(beat)) {
                if (fakeSyncData.includes(syncCursor)) {
                    noteOnLength = 0
                    value = 1
                }
            // } else {
            //     const currentLine = syncs[syncCursor]
            //     if (currentLine && currentLine.notes && !!currentLine.notes.find(note => note && note.Instrument === instrumentId)) {
            //         noteOnLength = 0
            //         value = 1
            //     }
            // }
        // } else {
            if (noteOnLength++ > noteLength) {
                value = value - noteDecay
            }
        // }
        instrumentData[3].push(Math.max(0, Math.min(1, value)))
    }
})
function readInstrumentSync (instrumentName) {
    const instrumentData = instrumentIds[instrumentName]
    const time = Math.floor(currentFrameTime * 100)
    const value = instrumentData[3][time]
    return value
}

let transport = null
let requestAnimationFrameId = null

function requestUpdate () {
    if (!framerateCap) {
        window.cancelAnimationFrame(requestAnimationFrameId)
        requestAnimationFrameId = window.requestAnimationFrame(update)
    } else {
        window.clearTimeout(requestAnimationFrameId)
        requestAnimationFrameId = window.setTimeout(update, 100)
    }
}

function startPressed () {
    transport.setIsPlaying(true, false)
    requestUpdate()
}

for (var i = 0; i < canvasBuffer.data.length; ++i) {
    canvasBuffer.data[i] = 255
}

window.main = function main (audio = window.audio) {
    console.log('Loaded!')

///
    window.AudioContext = window.AudioContext || window.webkitAudioContext
    const audioContext = new AudioContext()
    audioContext.decodeAudioData(audios['muzak'].buffer)
        .then(audioBuffer => {
            const rawDataLeft = audioBuffer.getChannelData(0)
            const rawDataRight = audioBuffer.getChannelData(1)
            const blockSize = audioBuffer.sampleRate / 50
            const blocks = Math.floor(rawDataLeft.length / blockSize)
            const blockData = []
            for (let i = 0; i < blocks; ++i) {
                const blockStart = i * blockSize
                let sum = 0
                for (let j = 0; j < blockSize; ++j) {
                    const pos = blockStart + j
                    const left = Math.abs(rawDataLeft[pos])
                    const right = Math.abs(rawDataRight[pos])
                    const max = Math.max(left, right)
                    sum += max
                }
                sum /= blockSize
                blockData.push(sum)
            }

            const multiplier = Math.pow(Math.max(...blockData), -1);
            audioSampleData = blockData.map(n => n * multiplier);
        })
///

    console.log("Ate Bit Presents: How I learned to stop worrying (and release a compofiller)")

    window.fitScreen()

    const params = new URLSearchParams(window.location.search)

    // if (params.has('nomusic')) {
    //     transport = new Transport(60 * 20)
    // } else {
        transport = new TransportMp3(audio)
    // }

    if (params.has('time')) {
        const time = parseInt(params.get('time')) * 60 / bpm
        transport.seekExact(time)
    }

    let reloadBlocksNoPlay = false
    if (params.has('devserver')) {
        reloadBlocksNoPlay = devserverInit()
    }

    if (params.has('controls')) {
        document.addEventListener('keydown', (event) => {
            const getSpeed = () => {
                if (event.shiftKey) return 1/60
                if (event.altKey) return 4
                return 1
            }
            const noControl = !event.shiftKey&&!event.altKey&&!event.ctrlKey
            if (event.key === ' ') {
                transport.setIsPlaying(!transport.getIsPlaying(), false)
                requestUpdate()
            } else if (noControl && event.key === 'ArrowUp' ) {
                transport.seekExact(0)
                requestUpdate()
            } else if (event.key === 'ArrowLeft' ) {
                transport.seekDelta(-getSpeed())
                requestUpdate()
            } else if (event.key === 'ArrowRight' ) {
                transport.seekDelta(getSpeed())
                requestUpdate()
            } else if (event.key === 'f') {
                openFullscreen()
            }
        })
    } else if (!params.has('dev')) {
        document.addEventListener('keydown', (event) => {
            if (event.key === ' ') {
                transport.setIsPlaying(!transport.getIsPlaying(), false)
                requestUpdate()
            } else if (event.key === 'f') {
                openFullscreen()
            }
        })
        document.addEventListener('click', () => {
            transport.setIsPlaying(true, false)
            requestUpdate()
        })
        canvas.addEventListener('touchstart', () => {
            transport.setIsPlaying(true, false)
            openFullscreen()
            requestUpdate()
        })
    }

    // const elDebuggo = document.getElementById('debugStuff')
    if (params.has('dev') && typeof Gui !== 'undefined') {
        gui = new Gui('gui')
        showDebugInfo = true
    } else {
        // elDebuggo.style = "display:none"
        gui = {
            startWindow: () => { return false },
            endWindow: () => {},
            addHotKey: () => {},
            endFrame: () => {},
            isReadyToRender: () => { return false },
        }
    }

    if (params.has('perf')) {
        doPerf = true
    }

    renderer = new Renderer(canvas, ctx)

    Object.values(entities).forEach(entity => {
        EntityAccessHelper.fromEntity(entity).init()
    })

    window.ctx.drawImage(overlays.opening, 0, 0)
    if (showDebugInfo) {
        if (!reloadBlocksNoPlay) transport.setIsPlaying(false, true)
        if (params.has('time')) {
            update()
        }
    }
}

let camViewPersp = m4.identity()

function openFullscreen() {
    if (canvas.requestFullscreen) {
        canvas.requestFullscreen()
    } else if (canvas.webkitRequestFullscreen) { /* Safari */
        canvas.webkitRequestFullscreen()
    } else if (canvas.msRequestFullscreen) { /* IE11 */
        canvas.msRequestFullscreen()
    }
}

let firstUpdate = false
let currentFrameTime = 0
let lastFrameTime = 0
async function update () {
    if (!firstUpdate) {
        console.log('Kick out the jams..')
        firstUpdate = true
    }
    fpsCounter++

    transport.update()
    const eahTransport = EntityAccessHelper.fromUuid(0)
    const audioSlip = eahTransport.staticConfig.audioSlip
    const frameTime = audioSlip + transport.getCurrentTime() / 60 * bpm // + 0.5 // sync fix?
    currentFrameTime = frameTime

    update_demo(frameTime)
    update_gui(frameTime)
    updateCommands()
    requestUpdate()
}

function update_demo (frameTime) {
    // Update all devices.
    Object.entries(entities)
        .filter(([uuid, entity]) => entity.type === 'device')
        .map(([uuid, entity]) => EntityAccessHelper.fromUuid(uuid))
        .filter(eah => eah.staticConfig.enabled)
        .forEach(eah => eah.actions.update(eah.self, eah.staticConfig))

    // Render everything through the transport.
    renderer.startFrame()
    modulesRunStrings = []
    moduleRunStringsIndent = 0
    {
        const eah = EntityAccessHelper.fromUuid('0')
        eah.actions.render(
            eah.self,
            frameTime,
            eah.combinedConfigs(frameTime),
            // eah.combinedConfigs(Math.floor(frameTime)), TODO UGH!!
            ctx)
    }
    renderer.endFrame()

    // Show debug texts.
    if (showDebugInfo) {
        ctx.globalAlpha = 1.0
        ctx.globalCompositeOperation = 'source-over'
        ctx.font = 'bold 32px sans-serif'
        let y = 10
        debugTexts.forEach(debugText => {
            const text = debugText
            ctx.textAlign = 'start'
            ctx.textBaseline = 'top'
            ctx.strokeStyle = '#000'
            ctx.strokeText(text, 10, y)
            ctx.fillStyle = '#fff'
            ctx.lineWidth = 8
            ctx.fillText(text, 10, y)
            y += 35
        })
    }
    debugTexts = []
}

function update_gui (frameTime) {
    if (modulesRunStrings) {
        frameTimeGraphData.shift()
        frameTimeGraphData.push(modulesRunStrings[0][2])
    }

    if (gui.isReadyToRender()) {
        guiProfilerWindow()
        guiAssetInfo()
        guiDevserver()
        guiCommandHistory()
        guiMidiLog()
        guiSyncs(frameTime)
        guiAudio(frameTime)
        guiRenderStats()
    
        guiEntityInfo()
        guiEntityEditorWindows(frameTime)

        guiRegisterHotKeys()

        gui.endFrame()
    }
}

function guiProfilerWindow () {
    if (gui.startWindow('Profiler', null, null, [new GuiText(fpsCount.toFixed(0))])) {
        if (modulesRunStrings) 
            modulesRunStrings.forEach(([indent, name, duration, entityId]) => {
                gui.startHorizontalGroup([15, 50, 35])
                    gui.addText(duration.toFixed(1))
                    gui.addText('  '.repeat(indent) + name)
                    if (entityId === '0') { 
                        gui.addGraph(frameTimeGraphData, {
                            suggestedMax: 100,
                            style: 'line',
                            height: 40,
                            gridLines: true,
                            gridSize: 10,
                        })
                    } else {
                        gui.addButton(entityId, () => {
                            transportOpenEditors.add(entityId)
                        })
                    }
                gui.endHorizontalGroup()
            })
    }
    gui.endWindow()
}

let assetInfoType = 'texture'
let assetInfoName = 'default'
function guiAssetInfo () {
    if (gui.startWindow('Asset Info')) {
        gui.addOptionInput('_t', assetInfoType, () => {
            return [
                {text:'model', value:'model'},
                {text:'texture', value:'texture'},
            ]
        }, (v) => {
            assetInfoType = v
            assetInfoName = 'default'
        })
        gui.addOptionInput('_n', assetInfoName, () => {
            return assetInfoType === 'model' ? getAllModelsAsOptions() : getAllColorTextureAsOptions()
        }, (v) => assetInfoName = v)
        
        function infoText(a, b) {
            gui.startHorizontalGroup([30, 70])
            gui.addText(a)
            gui.addText(b)
            gui.endHorizontalGroup()
        }

        if (assetInfoType === 'model') {
            const model = getModel(assetInfoName)
            infoText('Verts', String(model.verts.length))
            infoText('Normals', String(model.normals.length))
            infoText('Objects', String(model.objects.length))
            infoText('SubObjects', String(model.objects.reduce((p, c) => p + c.subObjects.length, 0)))
            const tris = model.objects.reduce((p, c) => p + c.subObjects.reduce((p, c) => p+c.tris.length, 0), 0)
            const quads = model.objects.reduce((p, c) => p + c.subObjects.reduce((p, c) => p+c.quads.length, 0), 0)
            infoText('Tris', String(tris))
            infoText('Quads', String(quads))
            infoText('Total Tris', String(tris + quads*2))
            // usage count..
        } else if (assetInfoType === 'texture') {
            const texture = getColorTexture(assetInfoName)
            infoText('Width', String(texture.width))
            infoText('Height', String(texture.height))
            // usage count..
        }
    }
    gui.endWindow()
}

function guiDevserver () {
    if (gui.startWindow('Devserver', null, null, [new GuiBlank(devserverState === 'opened' ? [0.25,.75,0.25] : [.75, 0.25, 0.25])])) {
        gui.startHorizontalGroup()
        gui.addText('Connection state')
        gui.addText(devserverState)
        gui.endHorizontalGroup()

        gui.startHorizontalGroup()
        gui.addText('Tx')
            gui.startHorizontalGroup()
            gui.addText(devServerSendCount.toString())
            gui.addPulse([0.25,.75,0.25], [0, 0, 0], devServerLastSendTime)
            gui.endHorizontalGroup()
        gui.endHorizontalGroup()

        gui.startHorizontalGroup()
        gui.addText('Rx')
            gui.startHorizontalGroup()
            gui.addText(devServerReceiveCount.toString())
            gui.addPulse([0.25,.75,0.25], [0, 0, 0], devServerLastReceiveTime)
            gui.endHorizontalGroup()
        gui.endHorizontalGroup()
    }
    gui.endWindow()
}

function guiCommandHistory () {
    if (gui.startWindow('Command History', null, null, [new GuiText(`${undoStack.length}/${redoStack.length}`)])) {
        gui.startHorizontalGroup([50, 50])
            gui.startVerticalGroup()
                gui.addText('Undo stack:')
                for (let i = 0; i < 5; ++i) {
                    if (i < undoStack.length) {
                        if (i !== 4) {
                            gui.addText(undoStack[i].commandType)
                        } else {
                            gui.addText('...')
                        }
                    } else {
                        gui.addBlank()
                    }
                }
            gui.endVerticalGroup()
            gui.startVerticalGroup()
                gui.addText('Redo stack:')
                for (let i = 0; i < 5; ++i) {
                    if (i < redoStack.length) {
                        if (i !== 4) {
                            gui.addText(redoStack[i].commandType)
                        } else {
                            gui.addText('...')
                        }
                    } else {
                        gui.addBlank()
                    }
                }
            gui.endVerticalGroup()
        gui.endHorizontalGroup()
    }
    gui.endWindow
}

function guiMidiLog () {
    if (gui.startWindow('MIDI Log', 700, null, [new GuiPulse([.25, .75, .25], [.0, .0, .0], midiLogLastTime, 1000)])) {
        gui.addText(midiLog)
    }
    gui.endWindow()
}

function guiSyncs (frameTime) {
    const width = 500
    if (gui.startWindow('Syncs', width)) {
        const startTime = frameTime - 2
        const scale = width / 6
        gui.addUserNode(new GuiNodeSyncs(startTime, scale, frameTime))
    }
    gui.endWindow()
}

function guiAudio (frameTime) {
    const width = 500
    if (gui.startWindow('Audio', width)) {
        const startTime = frameTime - 2
        const scale = width / 6
        gui.addUserNode(new GuiNodeAudio(startTime, scale, frameTime, 100))
    }
    gui.endWindow()
}

function guiRenderStats() {
    if (gui.startWindow('Render Stats')) {
        const renderStats = Object.entries(renderer.getRenderStats()).forEach(([name, value]) => {
            gui.startHorizontalGroup([70, 30])
            gui.addText(name)
            gui.addText(value.toString())
            gui.endHorizontalGroup()
        })
    }
    gui.endWindow()
}

let entityInfoSearchString = ''
function guiEntityInfo() {
    if (gui.startWindow('Entity Info', null, null, [new GuiText(Object.entries(entities).length.toString())])) {
        const entityData = Object.entries(entities)
            .map(([entityId, entityData]) => { return [entityData.name, entityId, entityData.type + '.' + entityData.subType]})
        const searchedEntityData = entityData.filter(x => x.some(y => y.includes(entityInfoSearchString)))

        gui.addParameter('Search', 'string', entityInfoSearchString, (newValue) => entityInfoSearchString = newValue)
        if (entityInfoSearchString) {
            gui.addText(`${searchedEntityData.length}/${entityData.length} entities`)
        } else {
            gui.addText(`${entityData.length} entities`)
        }
        gui.addBlank()

        if (gui.startScrollableSection(400, 400)) {
            searchedEntityData.forEach(text => {
                gui.addText(text)
                gui.addToggle(text[1], transportOpenEditors.has(text[1]), (newValue) => {
                    if (newValue) {
                        transportOpenEditors.add(text[1])
                    } else {
                        transportOpenEditors.delete(text[1])
                    }
                })
                gui.addBlank()
            })
        }
        gui.endScrollableSection()
    }
    gui.endWindow()
}

function guiEntityEditorWindows (frameTime) {
    let entityWasDeleted = false
    transportOpenEditors.forEach(entityId => {
        const entity = entities[entityId]
        if (entity) {
            const entityType = entity.type
            const entitySubType = entity.subType
            if (entityType === 'system' && entitySubType === 'transport') {
                transportEditor(entityId, frameTime)
            } else {
                genericEditor(entityId, frameTime)
            }
        } else {
            entityWasDeleted
        }
    })
    if (entityWasDeleted) {
        transportOpenEditors = new Set([...transportOpenEditors].filter(entity => entities[entity] !== undefined))
    }
}

function guiRegisterHotKeys () {
    gui.addHotKey('s', ['ctrl'], () => {
        renderer.saveImage()
    })
    gui.addHotKey(' ', [], () => {
        transport.setIsPlaying(!transport.getIsPlaying(), true)
    })
    gui.addHotKey(' ', ['shift'], () => {
        transport.setIsPlaying(!transport.getIsPlaying(), false)
    })
    const getSeekSpeed = (modifiers) => {
        if (modifiers.includes('alt')) return 1/60
        if (modifiers.includes('shift')) return 3/4*4
        return 3/4
    }

    gui.addHotKey('ArrowUp', [], () => transport.seekExact(0))
    gui.addHotKey('ArrowLeft', null, (modifiers) => transport.seekDelta(-getSeekSpeed(modifiers)))
    gui.addHotKey('ArrowRight', null, (modifiers) => transport.seekDelta(+getSeekSpeed(modifiers)))

    gui.addHotKey('z', ['ctrl'], () => undoCommand())
    gui.addHotKey('y', ['ctrl'], () => redoCommand())
}
